<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\BlogImage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class BlogsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            // dd($request->all());
            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Blog::select('count(*) as allcount')->count();
            $totalRecordswithFilter = Blog::select('count(*) as allcount')
                ->where('title', 'like', '%' . $searchValue . '%')
                ->orWhere('title_ar', 'like', '%' . $searchValue . '%')
                ->orWhere('sub_title', 'like', '%' . $searchValue . '%')
                ->orWhere('sub_title_ar', 'like', '%' . $searchValue . '%')
                ->count();

            $blogs = Blog::select('blogs.*')
                ->where('title', 'like', '%' . $searchValue . '%')
                ->orWhere('title_ar', 'like', '%' . $searchValue . '%')
                ->orWhere('sub_title', 'like', '%' . $searchValue . '%')
                ->orWhere('sub_title_ar', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('blogs.id', 'desc')
                ->get();


            $records = [];

            foreach($blogs as $item)
            {
                $records[] = [
                    'record_select' =>view('admin.blogs.datatable.record',[ 'item' => $item ])->render(),
                    'id' => $item->id,
                    'image' => $item->main_image ? '<img src="'. asset('storage/works/'.$item->main_image) .'" width="50">' : __('No image uploaded'),
                    'title' => \LaravelLocalization::getCurrentLocale() == 'ar' ? $item->title_ar : $item->title,
                    'sub_title' => \LaravelLocalization::getCurrentLocale() == 'ar' ? $item->sub_title_ar : $item->sub_title,
                    'actions' => view('admin.blogs.datatable.buttons',[ 'item' => $item ])->render() ,
                ];
            }

            $response = [
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordswithFilter,
                "aaData" => $records
            ];

            return response()->json($response);

        }

        return view('admin.blogs.index');
    }

    public function create()
    {
        # code...
        return view('admin.blogs.create');
    }

    public function store(Request $request)
    {
        # code...
        // dd($request->all());
        $request->validate([
            'main_image' => 'required|mimes:png,jpg,jpeg',
            'gallery' => 'nullable|array',
            'gallery.*' => 'mimes:png,jpg,jpeg',
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255',
            'sub_title' => 'required|string|max:255',
            'sub_title_ar' => 'required|string|max:255',
            'description' => 'nullable',
            'description_ar' => 'nullable',
            'tag_ar' => 'nullable',
            'tag' => 'nullable',
        ]);

        $data = $request->except(['gallery', 'main_image']);
        $main_image = null;
        
        $tags_array = null;
        if($request->tag)
                $tags_array = explode(',', $request->tag);

        $tags_array_ar = null;
        if($request->tag_ar)
            $tags_array_ar = explode(',', $request->tag_ar);


        if($request->hasFile('main_image') && $request->file('main_image')->isValid())
        {
            $main_image = $request->file('main_image')->store('/', 'works');
            $data['main_image'] = $main_image;
        }
        
        $data['tag'] = $tags_array;
        $data['tag_ar'] = $tags_array_ar;


        $blog = Blog::create($data);

        if(count($request->gallery ?? []) != 0)
            foreach($request->gallery as $key => $image)
            {
                $gallery = null;
                if($request->hasFile('gallery.' . $key) && $request->file('gallery.' . $key)->isValid())
                {
                    $gallery = $request->file('gallery.' . $key)->store('/', 'works');
                }
                $blog->images()->create([
                    'image' => $gallery,
                ]);
            }

        return redirect()->route('c-panel.blogs.index')->with('success', __('Added Done !'));

    }

    public function edit(Blog $blog)
    {
        # code...
        return view('admin.blogs.edit', [
            'blog' => $blog,
        ]);
    }

    public function update(Request $request, Blog $blog)
    {
        # code...
        $request->validate([
            'main_image' => 'nullable|mimes:png,jpg,jpeg',
            'gallery' => 'nullable|array',
            'gallery.*' => 'mimes:png,jpg,jpeg',
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255',
            'sub_title' => 'required|string|max:255',
            'sub_title_ar' => 'required|string|max:255',
            'description' => 'nullable',
            'description_ar' => 'nullable',
            'tag_ar' => 'nullable',
            'tag' => 'nullable',
        ]);

        $data = $request->except(['gallery', 'main_image']);
        $main_image = $blog->main_image;

        if($request->hasFile('main_image') && $request->file('main_image')->isValid())
        {
            if($blog->main_image)
                Storage::disk('works')->delete($blog->main_image);
            $main_image = $request->file('main_image')->store('/', 'works');
            $data['main_image'] = $main_image;
        }
        
        $tags_array = null;
        if($request->tag)
            $tags_array = explode(',', $request->tag);
        $tags_array_ar = null;
        if($request->tag_ar)
            $tags_array_ar = explode(',', $request->tag_ar);

        $data['tag'] = $tags_array;
        $data['tag_ar'] = $tags_array_ar;

        $blog->update($data);
        if(count($request->gallery ?? []) != 0)
            foreach($request->gallery as $key => $image)
            {
                $gallery = null;
                if($request->hasFile('gallery.' . $key) && $request->file('gallery.' . $key)->isValid())
                {
                    $gallery = $request->file('gallery.' . $key)->store('/', 'works');
                }
                $blog->images()->create([
                    'image' => $gallery,
                ]);
            }

        return redirect()->route('c-panel.blogs.index')->with('success', __('Updated Done !'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Blog $blog)
    {
        // $this->authorize('delete', $department);
        if($blog->main_image)
            Storage::disk('works')->delete($blog->main_image);

        if(count($blog->images) != 0)
            foreach($blog->images as $image){
                Storage::disk('works')->delete($image->image);
            }

        $blog->delete();
        return redirect()->route('c-panel.blogs.index')->with('success',__('Deleted Done !'));
    }

    public function bulkDelete()
    {
        // dd(json_decode(request()->record_ids));
        if(count(json_decode(request()->record_ids)) != 0){
            foreach (json_decode(request()->record_ids) as $recordId) {
                $blog = Blog::FindOrFail($recordId);
                // $this->authorize('delete', $blog);
                $this->delete($blog);
            }//end of for each
        }else{
            return redirect()->route('c-panel.blogs.index')->with('error',__('Please Select Record Before Delete'));
        }

        return redirect()->route('c-panel.blogs.index')->with('success',__('Selected  Deleted Done !'));
    }// end of bulkDelete

    private function delete(Blog $blog)
    {
        // $this->authorize('delete', $blog);

        if($blog->main_image)
            Storage::disk('works')->delete($blog->main_image);

        if(count($blog->images) != 0)
            foreach($blog->images as $image){
                Storage::disk('works')->delete($image->image);
            }

        $blog->delete();
    }

    public function deleteImagePost(Request $request)
    {
        # code...
        // dd($request);
        $imageName =  $request->get('filename');
        BlogImage::where('image', $imageName)->delete();
        Storage::disk('works')->delete($imageName);
        return response()->json([
            'name' => $request->filename,
        ]);
    }
}
