<?php $__env->startSection('pageTitle'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0"><?php echo e(__('الأشتراكات المستحقة')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e(__('الأشتراكات المستحقة')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(__('All Subscriptions')); ?></li>
                    </ol>
                </div> 
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <style>
        div.dataTables_wrapper div.dataTables_filter {
            float: left !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row"> 
    <div class="col-xl-3 col-md-6">
        <!-- card -->
        <div class="card card-animate">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1 overflow-hidden">
                        <p class="text-uppercase fw-medium text-muted text-truncate mb-0"> اجمالي الاشتراكات المستحقة</p>
                    </div> 
                </div>
                <div class="d-flex align-items-end justify-content-between mt-4">
                    <div>
                        <h6 class="fs-18 fw-semibold ff-secondary "> <?php echo e($count_subscriptions); ?> </h6> 
                    </div> 
                </div>
            </div><!-- end card body -->
        </div><!-- end card -->
    </div><!-- end col -->  
</div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex align-items-center ">
                    <h5 class="card-title mb-0 flex-grow-1"><?php echo e(__('الأشتراكات المستحقة')); ?></h5>
                    <div>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Subscription::class)): ?>
                        <a href="<?php echo e(route('c-panel.subscriptions.create')); ?>" class="btn btn-primary m-2"><?php echo e(__('Add New +')); ?></a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', App\Models\Subscription::first())): ?>
                        <button href="javascript:;" id="bulk-delete" class="btn btn-danger m-2" data-bs-toggle="modal" data-bs-target="#bulk-delete-items" disabled><?php echo e(__('Delete Selected')); ?></button>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <table id="subscriptionsdue-list-table" class="table nowrap align-middle dt-responsive" style="width:100%">
                        <thead>
                            <tr>
                                <th scope="col" style="width: 10px;">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" id="record__select-all">
                                    </div>
                                </th>
                                <th><?php echo e(__('ID')); ?></th>
                                <th><?php echo e(__('Customer')); ?></th>
                                <th><?php echo e(__('Subscription Type')); ?></th>
                                <th><?php echo e(__('Service End Date')); ?></th>
                                <th><?php echo e(__('Price')); ?></th>
                                <th><?php echo e(__('Subscription Status')); ?></th>
                                <th><?php echo e(__('Payment Status')); ?></th>
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!--end col-->
    </div>
    <!--end row-->

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', App\Models\Subscription::first())): ?>
    <!-- Delete Modal -->
    <div class="modal fade zoomIn" id="bulk-delete-items" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                </div>
                <div class="modal-body">
                    <form method="post" action="<?php echo e(route('c-panel.subscriptions.bulk-delete')); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('delete'); ?>
                        <input type="hidden" name="record_ids" id="record-ids" value="[]">
                        <div class="mt-2 text-center">
                            <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                            <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                <h4><?php echo e(__('Are you Sure ?')); ?></h4>
                                <p class="text-muted mx-4 mb-0"><?php echo e(__('Are you Sure You want to Remove Selected Records ?')); ?></p>
                            </div>
                        </div>
                        <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                            <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <button type="submit" class="btn w-sm btn-danger " id="delete-record"><?php echo e(__('Yes, Delete It!')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--end delete modal -->
    <?php endif; ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script>

        $(document).ready(function() {
            $("#subscriptionsdue-list-table").DataTable({
                "processing": true,
                "serverSide": true,
                ajax: {
                    url: '<?php echo e(route('c-panel.subscriptionsdue')); ?>'
                },
                columns: [
                    // columns according to JSON
                    {data: 'record_select', orderable: false},
                    {data: 'id', orderable: false},
                    {data: 'customer', orderable: false},
                    {data: 'type', orderable: false},
                    {data: 'end_date', orderable: false},
                    {data: 'price', orderable: false},
                    {data: 'status', orderable: false},
                    {data: 'status_0', orderable: false},
                    {data: 'actions', orderable: false}
                ],
                order: [1],
                language: {
                    sLengthMenu: '<?php echo e(__('Show _MENU_')); ?>',
                    search: '<?php echo e(__('Search :')); ?>',
                    zeroRecords: '<?php echo e(__('No matching records found')); ?>',
                    info: "<?php echo e(__('Showing _PAGE_ to _PAGES_')); ?>",
                    infoEmpty: '<?php echo e(__('Show 0 pages')); ?>',
                    searchPlaceholder: '<?php echo e(__('Search')); ?>..',
                    paginate: {
                        // remove previous & next text from pagination\
                        previous: '<?php echo e(__('Previous')); ?>',
                        next: '<?php echo e(__('Next')); ?>'
                    }
                },
            })
        });
    </script>



    <!-- App js -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\crm\resources\views/admin/subscriptions/subscriptionsdue.blade.php ENDPATH**/ ?>