<!DOCTYPE html>
<html lang="ar" dir="rtl" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <!-- App favicon -->
    <link rel="shortcut icon"
        href="<?php if($setting->footer_logo): ?> <?php echo e(asset('storage/' . $setting->footer_logo)); ?><?php else: ?><?php echo e(asset('assets/images/favicon.ico')); ?> <?php endif; ?>">

    <!-- Site Title  -->
    <title>
        <?php if(LaravelLocalization::getCurrentLocale() == 'ar'): ?>
            <?php echo e($setting->title_ar); ?><?php else: ?><?php echo e($setting->title); ?>

        <?php endif; ?> | <?php echo e(__('تسجيل دخول')); ?>

    </title>
    <!-- Bundle and Base CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('front/assets/css/vendor.bundle.css?ver=200')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/assets/css/style-salvia.css?ver=200')); ?>">

    <!-- Extra CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('front/assets/css/theme.css?ver=200')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/assets/css/rtl.css?ver=200')); ?>">
</head>

<body class="nk-body body-wider bg-light-alt has-rtl" dir="rtl">
    <div class="nk-wrap">
        <main class="nk-pages nk-pages-centered bg-theme">
            <div class="ath-container">
                <div class="ath-header text-center">
                    <a href="<?php echo e(route('view.home')); ?>" class="ath-logo"><img src="<?php echo e(asset('storage/works/' . $setting->footer_logo)); ?>"
                            srcset="<?php echo e(asset('storage/works/' . $setting->footer_logo)); ?>" width="200" alt="logo"></a>
                </div>
                <div class="ath-body">
                    <h5 class="ath-heading title"><?php echo e(__('تسجيل دخول')); ?></h5>
                    <?php if(Session::has('success')): ?>
                        <div class="alert alert-success p-2">
                            <?php echo e(Session::get('success')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if(Session::has('error')): ?>
                        <div class="alert alert-danger p-2">
                            <?php echo e(Session::get('error')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger p-2">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('login')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="text" class="input-bordered" name="email" value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(__('البريد الالكتروني')); ?>">
                            </div>
                        </div>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="password" class="input-bordered" name="password" placeholder="<?php echo e(__('كلمة المرور')); ?>">
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center pdb-r">
                            <div class="field-item pb-0">
                                <input class="input-checkbox" id="remember-me-2" type="checkbox" name="remember">
                                <label for="remember-me-2"> <?php echo e(__('تذكرنى')); ?></label>
                            </div>
                            
                        </div>
                        <button type="submit" class="btn btn-primary btn-block btn-md"><?php echo e(__('تسجيل الدخول')); ?></button>
                    </form>
                    
                </div>
                <div class="ath-note text-center tc-light"> <?php echo e(__('ليس لديك حساب؟')); ?> <a href="<?php echo e(route('register')); ?>"> <strong><?php echo e(__('سجل هنا')); ?>

                        </strong></a>
                </div>
            </div>
        </main>
    </div>
    <!-- Preloader -->
    <div class="preloader"><span class="spinner spinner-round"></span></div>
    <!-- JavaScript -->

    <script src="<?php echo e(asset('front/assets/js/jquery.bundle.js?ver=200')); ?>"></script>
    <script src="<?php echo e(asset('front/assets/js/scripts.js?ver=200')); ?>"></script>
    <script src="<?php echo e(asset('front/assets/js/charts.js?ver=200')); ?>"></script>
    <script src="<?php echo e(asset('front/assets/js/charts.js?ver=200')); ?>"></script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\crm\resources\views/auth/client/login.blade.php ENDPATH**/ ?>