<!DOCTYPE html>
<html lang="ar" dir="rtl" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <!-- App favicon -->
    <link rel="shortcut icon"
        href="@if ($setting->footer_logo) {{ asset('storage/' . $setting->footer_logo) }}@else{{ asset('assets/images/favicon.ico') }} @endif">

    <!-- Site Title  -->
    <title>
        @if (LaravelLocalization::getCurrentLocale() == 'ar')
            {{ $setting->title_ar }}@else{{ $setting->title }}
        @endif | {{ __('تسجيل دخول') }}
    </title>
    <!-- Bundle and Base CSS -->
    <link rel="stylesheet" href="{{ asset('front/assets/css/vendor.bundle.css?ver=200') }}">
    <link rel="stylesheet" href="{{ asset('front/assets/css/style-salvia.css?ver=200') }}">

    <!-- Extra CSS -->
    <link rel="stylesheet" href="{{ asset('front/assets/css/theme.css?ver=200') }}">
    <link rel="stylesheet" href="{{ asset('front/assets/css/rtl.css?ver=200') }}">
</head>

<body class="nk-body body-wider bg-light-alt has-rtl" dir="rtl">
    <div class="nk-wrap">
        <main class="nk-pages nk-pages-centered bg-theme">
            <div class="ath-container">
                <div class="ath-header text-center">
                    <a href="{{ route('view.home') }}" class="ath-logo"><img src="{{ asset('storage/works/' . $setting->footer_logo) }}"
                            srcset="{{ asset('storage/works/' . $setting->footer_logo) }}" width="200" alt="logo"></a>
                </div>
                <div class="ath-body">
                    <h5 class="ath-heading title">{{ __('اشتراك') }} <small class="tc-default">{{ __('قم بإنشاء حساب توكن ويز جديد') }}</small></h5>
                    <form action="{{ route('register') }}" method="POST">
                        @csrf
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="text" class="input-bordered" name="name" placeholder="{{ __('اسمك') }}">
                            </div>
                        </div>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="email" class="input-bordered" placeholder="{{ __('بريدك الالكتروني') }}" name="email">
                            </div>
                        </div>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="password" class="input-bordered" name="password" placeholder="{{ __('كلمة المرور') }}">
                            </div>
                        </div>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="password" class="input-bordered" name="password_confirmation" placeholder="{{ __('أعد كلمة المرور') }}">
                            </div>
                        </div>
                        <div class="field-item">
                            <input class="input-checkbox" id="agree-term-2" name="policy" value="1" type="checkbox">
                            <label for="agree-term-2">{{ __('أوافق على Icos') }} <a href="#">{{ __('سياسة خصوصية') }}</a> {{ __('و') }} <a href="#">{{ __('شروط') }}</a></label>
                        </div>
                        <button type="submit" class="btn btn-primary btn-block btn-md"> {{ __('اشتراك') }}</button>
                    </form>
                    {{-- <div class="sap-text"><span>أو اشترك مع</span></div>
                    <ul class="btn-grp gutter-20px gutter-vr-20px">
                        <li class="col"><a href="#" class="btn btn-md btn-facebook btn-block"><em class="icon fab fa-facebook-f"></em><span>فيسبوك</span></a></li>
                        <li class="col"><a href="#" class="btn btn-md btn-google btn-block"><em class="icon fab fa-google"></em><span>جوجل</span></a></li>
                    </ul> --}}
                </div>
                <div class="ath-note text-center tc-light"> {{ __('هل لديك حساب؟') }} <a href="{{ route('client.login') }}"> <strong>{{ __('تسجيل الدخول هنا') }}</strong></a>
                </div>
            </div>
        </main>
    </div>
    <!-- Preloader -->
    <div class="preloader"><span class="spinner spinner-round"></span></div>
    <!-- JavaScript -->

    <script src="{{ asset('front/assets/js/jquery.bundle.js?ver=200') }}"></script>
    <script src="{{ asset('front/assets/js/scripts.js?ver=200') }}"></script>
    <script src="{{ asset('front/assets/js/charts.js?ver=200') }}"></script>
    <script src="{{ asset('front/assets/js/charts.js?ver=200') }}"></script>
</body>

</html>
