<!DOCTYPE html>
<html lang="ar" dir="rtl" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <!-- App favicon -->
    <link rel="shortcut icon"
        href="@if ($setting->footer_logo) {{ asset('storage/' . $setting->footer_logo) }}@else{{ asset('assets/images/favicon.ico') }} @endif">

    <!-- Site Title  -->
    <title>
        @if (LaravelLocalization::getCurrentLocale() == 'ar')
            {{ $setting->title_ar }}@else{{ $setting->title }}
        @endif | {{ __('تسجيل دخول') }}
    </title>
    <!-- Bundle and Base CSS -->
    <link rel="stylesheet" href="{{ asset('front/assets/css/vendor.bundle.css?ver=200') }}">
    <link rel="stylesheet" href="{{ asset('front/assets/css/style-salvia.css?ver=200') }}">

    <!-- Extra CSS -->
    <link rel="stylesheet" href="{{ asset('front/assets/css/theme.css?ver=200') }}">
    <link rel="stylesheet" href="{{ asset('front/assets/css/rtl.css?ver=200') }}">
</head>

<body class="nk-body body-wider bg-light-alt has-rtl" dir="rtl">
    <div class="nk-wrap">
        <main class="nk-pages nk-pages-centered bg-theme">
            <div class="ath-container">
                <div class="ath-header text-center">
                    <a href="{{ route('view.home') }}" class="ath-logo"><img src="{{ asset('storage/works/' . $setting->footer_logo) }}"
                            srcset="{{ asset('storage/works/' . $setting->footer_logo) }}" width="200" alt="logo"></a>
                </div>
                <div class="ath-body">
                    <h5 class="ath-heading title">{{ __('تسجيل دخول') }}</h5>
                    @if (Session::has('success'))
                        <div class="alert alert-success p-2">
                            {{ Session::get('success') }}
                        </div>
                    @endif
                    @if (Session::has('error'))
                        <div class="alert alert-danger p-2">
                            {{ Session::get('error') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger p-2">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('login') }}">
                        @csrf
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="text" class="input-bordered" name="email" value="{{ old('email') }}" placeholder="{{ __('البريد الالكتروني') }}">
                            </div>
                        </div>
                        <div class="field-item">
                            <div class="field-wrap">
                                <input type="password" class="input-bordered" name="password" placeholder="{{ __('كلمة المرور') }}">
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center pdb-r">
                            <div class="field-item pb-0">
                                <input class="input-checkbox" id="remember-me-2" type="checkbox" name="remember">
                                <label for="remember-me-2"> {{ __('تذكرنى') }}</label>
                            </div>
                            {{-- <div class="forget-link fz-6">
                                <a href="page-reset.html">هل نسيت كلمة السر؟</a>
                            </div> --}}
                        </div>
                        <button type="submit" class="btn btn-primary btn-block btn-md">{{ __('تسجيل الدخول') }}</button>
                    </form>
                    {{-- <div class="sap-text"><span>أو قم بتسجيل الدخول باستخدام</span></div>
                    <ul class="row gutter-20px gutter-vr-20px">
                        <li class="col"><a href="#" class="btn btn-md btn-facebook btn-block"><em
                                    class="icon fab fa-facebook-f"></em><span>فيسبوك</span></a></li>
                        <li class="col"><a href="#" class="btn btn-md btn-google btn-block"><em
                                    class="icon fab fa-google"></em><span>جوجل</span></a></li>
                    </ul> --}}
                </div>
                <div class="ath-note text-center tc-light"> {{ __('ليس لديك حساب؟') }} <a href="{{ route('register') }}"> <strong>{{ __('سجل هنا') }}
                        </strong></a>
                </div>
            </div>
        </main>
    </div>
    <!-- Preloader -->
    <div class="preloader"><span class="spinner spinner-round"></span></div>
    <!-- JavaScript -->

    <script src="{{ asset('front/assets/js/jquery.bundle.js?ver=200') }}"></script>
    <script src="{{ asset('front/assets/js/scripts.js?ver=200') }}"></script>
    <script src="{{ asset('front/assets/js/charts.js?ver=200') }}"></script>
    <script src="{{ asset('front/assets/js/charts.js?ver=200') }}"></script>
</body>

</html>
