@extends('admin.layout.app')

@section('pageTitle')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">{{ __('Roles') }}</h4>

                <div class="page-title-right">
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addRole"><i
                        class="ri-add-fill me-1 align-bottom"></i> {{ __('Add Role') }}</button>
                </div>


            </div>
        </div>
    </div>
@stop

@section('css')
@stop

@section('content')

    <div class="row mt-4">
        @foreach ($roles as $role)
            @php
                $routes = [];
                foreach ($role->routes as $key => $value) {
                    # code...
                    $routes[] = $value->id;
                }
            @endphp
            <div class="col-xl-3 col-lg-6">
                <div class="card ribbon-box right overflow-hidden">
                    <div class="card-body p-4">
                        <h3 class="mb-3 mt-4"><a href="javascript:;" data-bs-toggle="modal"
                                data-bs-target="#editRole{{ $role->id }}"
                                class="link-primary">{{ $role->name }}</a></h3>
                        @if(in_array(1, $routes) || in_array(2, $routes) || in_array(3, $routes) || in_array(4, $routes))<p>- {{ __('Manage') }} {{ __('Departments') }}</p>@endif
                        @if(in_array(6, $routes) || in_array(7, $routes) || in_array(8, $routes) || in_array(9, $routes))<p>- {{ __('Manage') }} {{ __('Services') }}</p>@endif
                        @if(in_array(11, $routes) || in_array(12, $routes) || in_array(13, $routes) || in_array(14, $routes))<p>- {{ __('Manage') }} {{ __('Plans') }}</p>@endif
                        @if(in_array(16, $routes) || in_array(17, $routes) || in_array(18, $routes) || in_array(19, $routes))<p>- {{ __('Manage') }} {{ __('Domins') }}</p> @endif
                        @if(in_array(21, $routes) || in_array(22, $routes) || in_array(23, $routes) || in_array(24, $routes))<p>- {{ __('Manage') }} {{ __('Subscriptions') }}</p>@endif
                        @if(in_array(26, $routes) || in_array(27, $routes) || in_array(28, $routes) || in_array(29, $routes))<p>- {{ __('Manage') }} {{ __('Offers') }}</p>@endif
                        @if(in_array(31, $routes) || in_array(32, $routes) || in_array(33, $routes) || in_array(34, $routes))<p>- {{ __('Manage') }} {{ __('Invoices') }}</p>@endif
                        @if(in_array(36, $routes) || in_array(37, $routes) || in_array(38, $routes) || in_array(39, $routes))<p>- {{ __('Manage') }} {{ __('All Customers') }}</p>@endif
                        @if(in_array(40, $routes))<p>- {{ __('Manage') }} {{ __('Content') }}</p>@endif
                        <div class="mt-4 d-flex">
                            <a href="javascript:;" class="btn btn-primary m-1" data-bs-toggle="modal" data-bs-target="#editRole{{ $role->id }}"><i class="ri-edit-box-line"></i></a>
                            <a href="javascript:;" class="btn btn-danger m-1" data-bs-toggle="modal" data-bs-target="#delete-item-{{ $role->id }}"><i class="ri-delete-bin-6-line"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <!--end col-->
        @endforeach
    </div>
    <!--end row-->

    <div class="row g-0 text-center text-sm-start align-items-center mb-3">
        <!-- end col -->
        <div class="col-sm-12">
            {{ $roles->links('vendor.pagination.semantic-ui') }}
        </div><!-- end col -->
    </div><!-- end row -->

    <!-- Modal -->
    <div class="modal fade zoomIn" id="addRole" tabindex="-1" aria-labelledby="addSellerLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addSellerLabel">{{ __('Add Role') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('c-panel.roles.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-5">
                                    <label for="name" class="form-label">{{ __('Role Name') }}</label>
                                    <input type="text" class="form-control" id="name" name="name"
                                        value="{{ old('name') }}" placeholder="{{ __('Enter role name') }}">
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12">
                                <div class="mb-2">
                                    <div class="row">
                                        <div class="col-3"><label class="form-label">{{ __('Role Permissions') }}</label></div>
                                        <div class="col-9">
                                            <div class="form-check">
                                                <input class="form-check-input" onchange="selectAll()" type="checkbox" id="select-all">
                                                <label class="form-check-label" for="select-all">
                                                    {{ __('Select All') }}
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <table class="table table-nowrap text-start">
                                        <thead>
                                            <tr>
                                                <th>{{ __('Permission') }}</th>
                                                <th>{{ __('View') }}</th>
                                                <th>{{ __('Create') }}</th>
                                                <th>{{ __('Update') }}</th>
                                                <th>{{ __('Delete') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>{{ __('Departments') }}</td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route1" name="routes[]" value="1"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route2" name="routes[]" value="2"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route3" name="routes[]" value="3"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route4" name="routes[]" value="4"></td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('Customer') }}</td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route36" name="routes[]" value="36"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route37" name="routes[]" value="37"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route38" name="routes[]" value="38"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route39" name="routes[]" value="39"></td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('Services') }}</td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route6" name="routes[]" value="6"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route7" name="routes[]" value="7"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route8" name="routes[]" value="8"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route9" name="routes[]" value="9"></td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('Plans') }}</td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route11" name="routes[]" value="11"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route12" name="routes[]" value="12"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route13" name="routes[]" value="13"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route14" name="routes[]" value="14"></td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('Domins') }}</td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route16" name="routes[]" value="16"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route17" name="routes[]" value="17"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route18" name="routes[]" value="18"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route19" name="routes[]" value="19"></td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('Subscriptions') }}</td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route21" name="routes[]" value="21"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route22" name="routes[]" value="22"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route23" name="routes[]" value="23"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route24" name="routes[]" value="24"></td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('Offers') }}</td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route26" name="routes[]" value="26"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route27" name="routes[]" value="27"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route28" name="routes[]" value="28"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route29" name="routes[]" value="29"></td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('Invoices') }}</td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route31" name="routes[]" value="31"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route32" name="routes[]" value="32"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route33" name="routes[]" value="33"></td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route34" name="routes[]" value="34"></td>
                                            </tr>
                                            <tr>
                                                <td>{{ __('Content Managment') }}</td>
                                                <td><input class="form-check-input create-check" onchange="chechAll()" type="checkbox" id="route40" name="routes[]" value="40"></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                        </tbody>
                                    </table>

                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                        data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                        {{ __('Close') }}</button>
                                    <button type="submit" class="btn btn-primary"><i
                                            class="ri-save-3-line align-bottom me-1"></i> {{ __('Save') }}</button>
                                </div>
                            </div>
                            <!--end col-->
                        </div>
                        <!--end row-->
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--end modal-->

    @foreach ($roles as $role)
        <!-- Modal -->
        <div class="modal fade zoomIn" id="editRole{{ $role->id }}" tabindex="-1"
            aria-labelledby="addSellerLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addSellerLabel">{{ __('Edit Role') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="{{ route('c-panel.roles.update', $role->id) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="mb-5">
                                        <label for="name" class="form-label">{{ __('Role Name') }}</label>
                                        <input type="text" class="form-control" id="name" name="name"
                                            value="{{ old('name', $role->name) }}" placeholder="{{ __('Enter role name') }}">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-12">
                                    <div class="mb-2">
                                        <div class="row">
                                            <div class="col-4"><label class="form-label">{{ __('Role Permissions') }}</label></div>
                                            <div class="col-8">
                                                <div class="form-check">
                                                    <input class="form-check-input" onchange="selectAll{{ $role->id }}()" type="checkbox" id="select-all{{ $role->id }}">
                                                    <label class="form-check-label" for="select-all">
                                                        {{ __('Select All') }}
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <!--end col-->
                                @php
                                    $route_ids = [];
                                    foreach ($role->routes as $key => $value) {
                                        # code...
                                        $route_ids[] = $value->id;
                                    }
                                @endphp
                                <div class="col-lg-12">
                                    <div class="mb-3">
                                        <table class="table table-nowrap text-start">
                                            <thead>
                                                <tr>
                                                    <th>{{ __('Permission') }}</th>
                                                    <th>{{ __('View') }}</th>
                                                    <th>{{ __('Create') }}</th>
                                                    <th>{{ __('Update') }}</th>
                                                    <th>{{ __('Delete') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{{ __('Departments') }}</td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route1" name="routes[]" @if(in_array(1, $route_ids)) checked @endif value="1"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route2" name="routes[]" @if(in_array(2, $route_ids)) checked @endif value="2"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route3" name="routes[]" @if(in_array(3, $route_ids)) checked @endif value="3"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route4" name="routes[]" @if(in_array(4, $route_ids)) checked @endif value="4"></td>
                                                </tr>
                                                <tr>
                                                    <td>{{ __('Customer') }}</td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route36" name="routes[]" @if(in_array(36, $route_ids)) checked @endif value="36"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route37" name="routes[]" @if(in_array(37, $route_ids)) checked @endif value="37"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route38" name="routes[]" @if(in_array(38, $route_ids)) checked @endif value="38"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route39" name="routes[]" @if(in_array(39, $route_ids)) checked @endif value="39"></td>
                                                </tr>
                                                <tr>
                                                    <td>{{ __('Services') }}</td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route6" name="routes[]" @if(in_array(6, $route_ids)) checked @endif value="6"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route7" name="routes[]" @if(in_array(7, $route_ids)) checked @endif value="7"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route8" name="routes[]" @if(in_array(8, $route_ids)) checked @endif value="8"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route9" name="routes[]" @if(in_array(9, $route_ids)) checked @endif value="9"></td>
                                                </tr>
                                                <tr>
                                                    <td>{{ __('Plans') }}</td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route11" name="routes[]" @if(in_array(11, $route_ids)) checked @endif value="11"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route12" name="routes[]" @if(in_array(12, $route_ids)) checked @endif value="12"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route13" name="routes[]" @if(in_array(13, $route_ids)) checked @endif value="13"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route14" name="routes[]" @if(in_array(14, $route_ids)) checked @endif value="14"></td>
                                                </tr>
                                                <tr>
                                                    <td>{{ __('Domins') }}</td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route16" name="routes[]" @if(in_array(16, $route_ids)) checked @endif value="16"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route17" name="routes[]" @if(in_array(17, $route_ids)) checked @endif value="17"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route18" name="routes[]" @if(in_array(18, $route_ids)) checked @endif value="18"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route19" name="routes[]" @if(in_array(19, $route_ids)) checked @endif value="19"></td>
                                                </tr>
                                                <tr>
                                                    <td>{{ __('Subscriptions') }}</td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route21" name="routes[]" @if(in_array(21, $route_ids)) checked @endif value="21"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route22" name="routes[]" @if(in_array(22, $route_ids)) checked @endif value="22"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route23" name="routes[]" @if(in_array(23, $route_ids)) checked @endif value="23"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route24" name="routes[]" @if(in_array(24, $route_ids)) checked @endif value="24"></td>
                                                </tr>
                                                <tr>
                                                    <td>{{ __('Offers') }}</td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route26" name="routes[]" @if(in_array(26, $route_ids)) checked @endif value="26"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route27" name="routes[]" @if(in_array(27, $route_ids)) checked @endif value="27"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route28" name="routes[]" @if(in_array(28, $route_ids)) checked @endif value="28"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route29" name="routes[]" @if(in_array(29, $route_ids)) checked @endif value="29"></td>
                                                </tr>
                                                <tr>
                                                    <td>{{ __('Invoices') }}</td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route31" name="routes[]" @if(in_array(31, $route_ids)) checked @endif value="31"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route32" name="routes[]" @if(in_array(32, $route_ids)) checked @endif value="32"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route33" name="routes[]" @if(in_array(33, $route_ids)) checked @endif value="33"></td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route34" name="routes[]" @if(in_array(34, $route_ids)) checked @endif value="34"></td>
                                                </tr>
                                                <tr>
                                                    <td>{{ __('Content Managment') }}</td>
                                                    <td><input class="form-check-input edit-check{{ $role->id }}"  onchange="chechAll{{ $role->id }}()" type="checkbox" id="{{ $role->id }}route40" name="routes[]" @if(in_array(40, $route_ids)) checked @endif value="40"></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="button" class="btn btn-link link-success text-decoration-none fw-medium"
                                            data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i>
                                            {{ __('Close') }}</button>
                                        <button type="submit" class="btn btn-primary"><i
                                                class="ri-save-3-line align-bottom me-1"></i> {{ __('Save') }}</button>
                                    </div>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--end modal-->

        <!-- Delete Modal -->
        <div class="modal fade zoomIn" id="delete-item-{{ $role->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                            id="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <form action=" {{ route('c-panel.roles.destroy', $role->id) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <div class="mt-2 text-center">
                                <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop"
                                    colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px">
                                </lord-icon>
                                <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                    <h4>{{ __('Are you Sure ?') }}</h4>
                                    <p class="text-muted mx-4 mb-0">
                                        {{ __('Are you Sure You want to Remove this Record ?') }}</p>
                                </div>
                            </div>
                            <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                <button type="button" class="btn w-sm btn-light"
                                    data-bs-dismiss="modal">{{ __('Close') }}</button>
                                <button type="submit" class="btn w-sm btn-danger "
                                    id="delete-record">{{ __('Yes, Delete It!') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--end delete modal -->
    @endforeach

@stop

@section('js')
    {{-- <!-- ckeditor -->
    <script src="{{ asset('assets/libs/@ckeditor/ckeditor5-build-classic/build/ckeditor.js') }}"></script>

    <!-- dropzone js -->
    <script src="{{ asset('assets/libs/dropzone/dropzone-min.js') }}"></script>
    <script src="{{ asset('assets/js/pages/ecommerce-product-create.init.js') }}"></script> --}}

    <script>
        var select_all = document.getElementById("select-all");
        var allInputs = document.getElementsByClassName('create-check');
        function selectAll(){
            if(select_all.checked == true){
                for (let i = 0; i < allInputs.length; i++) {
                    allInputs[i].checked = true;
                };
            } else {
                for (let i = 0; i < allInputs.length; i++) {
                    allInputs[i].checked = false;
                };
            }

        }

        function chechAll(){
            var count = 0;

            for (let i = 0; i < allInputs.length; i++) {
                if(allInputs[i].checked == true){
                    count++;
                } else {
                    count--;
                }
            };

            if(count == allInputs.length){
                select_all.checked = true;
            } else {
                select_all.checked = false;
            }
        }

        @foreach ($roles as $role)
            var select_all{{ $role->id }} = document.getElementById("select-all{{ $role->id }}");
            var allInputs{{ $role->id }} = document.getElementsByClassName('edit-check{{ $role->id }}');
            function selectAll{{ $role->id }}(){
                if(select_all{{ $role->id }}.checked == true){
                    for (let i = 0; i < allInputs{{ $role->id }}.length; i++) {
                        allInputs{{ $role->id }}[i].checked = true;
                    };
                } else {
                    for (let i = 0; i < allInputs{{ $role->id }}.length; i++) {
                        allInputs{{ $role->id }}[i].checked = false;
                    };
                }

            }

            function chechAll{{ $role->id }}(){
                var count{{ $role->id }} = 0;

                for (let i = 0; i < allInputs{{ $role->id }}.length; i++) {
                    if(allInputs{{ $role->id }}[i].checked == true){
                        count{{ $role->id }}++;
                    } else {
                        count{{ $role->id }}--;
                    }
                };

                if(count{{ $role->id }} == allInputs{{ $role->id }}.length){
                    select_all{{ $role->id }}.checked = true;
                } else {
                    select_all{{ $role->id }}.checked = false;
                }
            }


            window.onload = function() {
                chechAll{{ $role->id }}();
            };
        @endforeach
    </script>

@stop
