<!doctype html>
<html lang="en" data-layout="horizontal" data-topbar="dark" data-sidebar="dark" data-sidebar-size="lg"
    data-sidebar-image="none" data-preloader="disable" dir="rtl">

<head>

    <meta charset="utf-8" />
    <title>{{ LaravelLocalization::getCurrentLocale() == 'ar' ? $setting->title_ar : $setting->title }} | @yield('title')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="@if($setting->footer_logo){{ asset('storage/works/'.$setting->footer_logo) }}@else{{ asset('assets/images/favicon.ico') }}@endif">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Alexandria:wght@200;300&display=swap" rel="stylesheet">

    @include('admin.layout.head')

    @yield('css')
    <script src="//cdn.ckeditor.com/4.16.0/full/ckeditor.js"></script>
    @if(LaravelLocalization::getCurrentLocale() == 'ar')
    <style>
        .h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6 {
            font-family: 'Alexandria', sans-serif;
        }
    </style>
    @endif
</head>

<body @if(LaravelLocalization::getCurrentLocale() == 'ar') style="font-family: 'Alexandria', sans-serif;" @endif>
    <!-- Begin page -->
    <div id="layout-wrapper">
        @include('admin.layout.header')
        <!-- ========== App Menu ========== -->
        @include('admin.layout.menu')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    @yield('pageTitle')
                    <!-- end page title -->


                    @yield('content')

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->
            @include('admin.layout.footer')
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->



    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    @include('admin.layout.js')

    @yield('js')


    <x-alerts />

</body>

</html>
