@extends('admin.layout.app')

@section('pageTitle')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">{{ __('Plans') }}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ __('Services Group') }}</a></li>
                        <li class="breadcrumb-item active">{{ $group->name }}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
@stop

@section('css')
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <style>
        div.dataTables_wrapper div.dataTables_filter {
            float: left !important;
        }
    </style>
@stop

@section('content')

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex align-items-center ">
                    <h5 class="card-title mb-0 flex-grow-1">{{ __('Plans') }}</h5>
                    <div>
                        @can('create', App\Models\Plan::class)
                        <a href="{{ route('c-panel.plans.create', $group->id) }}" class="btn btn-primary m-2">{{ __('Add New +') }}</a>
                        @endcan
                        @can('delete', App\Models\Plan::first())
                        <button href="javascript:;" id="bulk-delete" class="btn btn-danger m-2" data-bs-toggle="modal" data-bs-target="#bulk-delete-items" disabled>{{ __('Delete Selected') }}</button>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <table id="plans-list-table" class="table nowrap align-middle dt-responsive" style="width:100%">
                        <thead>
                            <tr>
                                <th scope="col" style="width: 10px;">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" id="record__select-all">
                                    </div>
                                </th>
                                <th>{{ __('Plan Title') }}</th>
                                <th>{{ __('Descritpion') }}</th>
                                <th>{{ __('السعر السنوي') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!--end col-->
    </div>
    <!--end row-->

    @can('delete', App\Models\Plan::first())
    <!-- Delete Modal -->
    <div class="modal fade zoomIn" id="bulk-delete-items" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                </div>
                <div class="modal-body">
                    <form method="post" action="{{ route('c-panel.plans.bulk-delete') }}">
                        @csrf
                        @method('delete')
                        <input type="hidden" name="record_ids" id="record-ids" value="[]">
                        <div class="mt-2 text-center">
                            <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                            <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                <h4>{{ __('Are you Sure ?') }}</h4>
                                <p class="text-muted mx-4 mb-0">{{ __('Are you Sure You want to Remove Selected Records ?') }}</p>
                            </div>
                        </div>
                        <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                            <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                            <button type="submit" class="btn w-sm btn-danger " id="delete-record">{{ __('Yes, Delete It!') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--end delete modal -->
    @endcan


@stop

@section('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script>

        $(document).ready(function() {
            $("#plans-list-table").DataTable({
                "processing": true,
                "serverSide": true,
                ajax: {
                    url: '{{ route('c-panel.plans.index', $group->id) }}'
                },
                columns: [
                    // columns according to JSON
                    {data: 'record_select', orderable: false},
                    {data: 'title', orderable: false},
                    {data: 'description', orderable: false},
                    {data: 'Annual', orderable: false},
                    {data: 'actions', orderable: false}
                ],
                order: [1],
                language: {
                    sLengthMenu: '{{ __('Show _MENU_') }}',
                    search: '{{ __('Search :') }}',
                    zeroRecords: '{{ __('No matching records found') }}',
                    info: "{{ __('Showing _PAGE_ to _PAGES_') }}",
                    infoEmpty: '{{ __('Show 0 pages') }}',
                    searchPlaceholder: '{{__('Search')}}..',
                    paginate: {
                        // remove previous & next text from pagination\
                        previous: '{{ __('Previous') }}',
                        next: '{{ __('Next') }}'
                    }
                },
            })
        });
    </script>



    <!-- App js -->

@stop
