<div class="dropdown d-inline-block">
    <button class="btn btn-soft-secondary btn-sm dropdown" type="button"
        data-bs-toggle="dropdown" aria-expanded="false">
        <i class="ri-more-fill align-middle"></i>
    </button>
    <ul class="dropdown-menu dropdown-menu">
        {{-- <li>
            <a href="#!" class="dropdown-item">
                {{ __('View') }} <i class="ri-eye-fill align-bottom me-2 text-muted"></i>
            </a>
        </li> --}}
        @can('update', $item)
        <li>
            <a class="dropdown-item edit-item-btn" href="{{ route('c-panel.plans.edit', $item->id) }}">
                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> {{ __('Edit') }}
            </a>
        </li>
        @endcan
        @can('delete', $item)
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#delete-item-{{ $item->id }}">
                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> {{ __('Delete') }}
            </a>
        </li>
        @endcan
    </ul>
</div>


@can('delete', $item)
<!-- Delete Modal -->
<div class="modal fade zoomIn" id="delete-item-{{ $item->id }}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" {{ route('c-panel.plans.destroy',$item->id) }}"
                    method="POST">
                    @csrf
                    @method('DELETE')
                    <div class="mt-2 text-center">
                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4>{{ __('Are you Sure ?') }}</h4>
                            <p class="text-muted mx-4 mb-0">{{ __('Are you Sure You want to Remove this Record ?') }}</p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn w-sm btn-danger " id="delete-record">{{ __('Yes, Delete It!') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->
@endcan
