<div class="dropdown d-inline-block">
    <button class="btn btn-soft-secondary btn-sm dropdown" type="button"
        data-bs-toggle="dropdown" aria-expanded="false">
        <i class="ri-more-fill align-middle"></i>
    </button>
    <ul class="dropdown-menu dropdown-menu">
        @can('viewAny', App\Models\Plan::class)
        <li>
            <a href="{{ route('c-panel.plans.index', $item->id) }}" class="dropdown-item">
                <i class="ri-eye-fill align-bottom me-2 text-muted"></i> {{ __('Plans') }}
            </a>
        </li>
        @endcan
        @can('update', $item)
        <li>
            <a class="dropdown-item edit-item-btn" data-bs-toggle="modal" data-bs-target="#edit-item-{{ $item->id }}">
                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> {{ __('Edit') }}
            </a>
        </li>
        @endcan
        @can('delete', $item)
        <li>
            <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" data-bs-target="#delete-item-{{ $item->id }}">
                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> {{ __('Delete') }}
            </a>
        </li>
        @endcan
    </ul>
</div>


@can('delete', $item)
<!-- Delete Modal -->
<div class="modal fade zoomIn" id="delete-item-{{ $item->id }}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
            </div>
            <div class="modal-body">
                <form action=" {{ route('c-panel.groups.destroy',$item->id) }}"
                    method="POST">
                    @csrf
                    @method('DELETE')
                    <div class="mt-2 text-center">
                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4>{{ __('Are you Sure ?') }}</h4>
                            <p class="text-muted mx-4 mb-0">{{ __('Are you Sure You want to Remove this Record ?') }}</p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn w-sm btn-danger " id="delete-record">{{ __('Yes, Delete It!') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--end delete modal -->
@endcan

@can('update', $item)
<!-- Edit Modal -->
<div class="modal fade" id="edit-item-{{ $item->id }}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light p-3">
                <h5 class="modal-title" id="exampleModalLabel">{{ __('Edit Services Group') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
            </div>
            <form action="{{ route('c-panel.groups.update', $item->id ) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <label for="image">{{ __('Image') }}</label>
                    <div class="mb-3">
                        <div class="position-relative d-inline-block" style="width: 60%">
                            <input type='file'
                                onchange="loadFile_image{{ $item->id }}(image{{ $item->id }})"
                                name="image" id="image{{ $item->id }}"
                                class="@error('image{{ $item->id }}') is-invalid @enderror"
                                style="display:none;" />
                            <button id="output_image{{ $item->id }}" type="button" class="bg-light"
                                onclick="document.getElementById('image{{ $item->id }}').click();"
                                value="emad"
                                style="
                                    width: 100%;
                                    height: 150px;
                                    border-radius: 2px;
                                    background-repeat: no-repeat;
                                    background-image: url({{ asset('storage/' . ($item->image ?? '')) }});
                                    background-size: cover;
                                    background-position: center;
                                    border:none;
                                    "></button>
                            <div class="position-absolute top-100 start-100 translate-middle">
                                <label for="product-image-input"
                                    onclick="document.getElementById('image{{ $item->id }}').click();"
                                    class="mb-0" title="Select Image">
                                    <div class="avatar-xs">
                                        <div
                                            class="avatar-title bg-light border rounded-circle text-muted cursor-pointer">
                                            <i class="ri-image-fill"></i>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        <script>
                            var loadFile_image{{ $item->id }} = function(image{{ $item->id }}) {
                                var image{{ $item->id }} = document.getElementById('output_image{{ $item->id }}');
                                var src = URL.createObjectURL(event.target.files[0]);
                                image{{ $item->id }}.style.backgroundImage = 'url(' + src + ')';
                            };
                        </script>
                    </div>
                    <div class="mb-3">
                        <label for="name_ar" class="form-label">{{ __('Arabic Group Name') }}</label>
                        <input type="text" id="name_ar" name="name_ar" value="{{ $item->name_ar }}" class="form-control" required />
                    </div>
                    <div class="mb-3">
                        <label for="name" class="form-label">{{ __('English Group Name') }}</label>
                        <input type="text" id="name" name="name" value="{{ $item->name }}" class="form-control" required />
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">{{ __('English Description') }}</label>
                        <textarea  id="description" name="description" class="form-control" rows="3" >{{ old('description', $item->description) }}</textarea>
                    </div>
                    <div class="mb-3">
                        <label for="description_ar" class="form-label">{{ __('Arabic Description') }}</label>
                        <textarea  id="description_ar" name="description_ar" class="form-control" rows="3">{{ old('description_ar', $item->description_ar) }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="hstack gap-2 justify-content-end">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn btn-success" id="add-btn">{{ __('Update') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!--end edit modal -->
@endcan
