<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->enum('type', [0,1])->nullable();
            $table->foreignId('domin_id')->nullable()->constrained('domins')->nullOnDelete();
            $table->foreignId('plan_id')->nullable()->constrained('plans')->nullOnDelete();
            $table->unsignedBigInteger('price_type')->nullable();
            $table->string('price')->nullable();
            $table->string('start_date')->nullable();
            $table->string('subscrip_date')->nullable();
            $table->string('due_date')->nullable();
            $table->string('end_date')->nullable();
            $table->unsignedBigInteger('status')->nullable();
            $table->unsignedBigInteger('status_0')->nullable();
            $table->string('discount')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subscriptions');
    }
};
