<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use HasFactory;

    protected $fillable = [
        'group_id', 'title', 'description'
    ];

    public function group()
    {
        # code...
        return $this->belongsTo(Group::class, 'group_id', 'id');
    }

    public function features()
    {
        # code...
        return $this->hasMany(PlanFeature::class, 'plan_id', 'id');
    }

    public function prices()
    {
        # code...
        return $this->hasMany(PlanPrice::class, 'plan_id', 'id');
    }
}
