<?php

namespace App\Jobs;

use App\Models\Bill;
use App\Models\Subscription;
use App\Models\WebsiteSetting;
use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class ConvertSubscriptionJop implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $subscriptions = Subscription::where([['due_date', Carbon::now()->format('Y-m-d')]])->get();

        $end_subscription = Subscription::where('end_date', Carbon::now()->format('Y-m-d'))->get();

        foreach($subscriptions as $sub)
        {
            $bill = Bill::create([
                'customer_id' => $sub->user_id,
                'date' => $sub->due_date,
                'end_date' => $sub->end_date,
                'currancy' => 1,
                'totel' => 0,
                'status' => 1
            ]);

            if($sub->type == 0){
                $service_name = $sub->plan->group->name . ' ' . $sub->plan->title;
                $service_price = (float) $sub->price;
                $service_discount = (float) $sub->discount;
                $service_totel = 0;
                $service_tax = (float) $sub->tax;
                $discountTotal = 0;
                $taxTotal = 0;

                if($sub->discount){
                    $discountTotal = (float) ((float) $sub->price * ((float)$sub->discount / 100));
                }

                if($sub->tax){
                    $taxTotal = (float) ((float) $sub->price * ((float)$sub->tax / 100));
                }

                $service_totel = (((float) $sub->price) + $taxTotal) - $discountTotal;

                $bill->services()->create([
                    'name' => $service_name,
                    'price' => $service_price,
                    'discount' => $service_discount,
                    'totel' => $service_totel,
                    'tax' => $service_tax,
                ]);
            } else {
                $service_name = $sub->domin->name;
                $service_price = (float) $sub->price;
                $service_discount = (float) $sub->discount;
                $service_totel = 0;
                $service_tax = (float) $sub->tax;
                $discountTotal = 0;
                $taxTotal = 0;

                if($sub->discount){
                    $discountTotal = (float) ((float) $sub->price * ((float)$sub->discount / 100));
                }

                if($sub->tax){
                    $taxTotal = (float) ((float) $sub->price * ((float)$sub->tax / 100));
                }

                $service_totel = (((float) $sub->price) + $taxTotal) - $discountTotal;

                $bill->services()->create([
                    'name' => $service_name,
                    'price' => $service_price,
                    'discount' => $service_discount,
                    'totel' => $service_totel,
                    'tax' => $service_tax,
                ]);
            }

            $bill->update([
                'totel' => $service_totel,
            ]);

            $mail_data1 = [
                'recipient' => $bill->customer->email,
                'fromEmail' => env('MAIL_FROM_ADDRESS','ahmer631998@gmail.com'),
                'fromName' => WebsiteSetting::first()->title ?? '',
                'bill' => $bill,
                'title' => __('Financial due bill'),
            ];
            Mail::send('admin.bills.email-template',$mail_data1,function($message) use ($mail_data1){
                $message->to($mail_data1['recipient'])
                        ->from($mail_data1['fromEmail'],$mail_data1['fromName'])
                        ->subject($mail_data1['title']);
            });
        }

        foreach($end_subscription as $item){
            $item->update([
                'discount' => 0,
                'tax' => 0,
            ]);
        }
    }
}
