<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\WebsiteSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class SettingController extends Controller
{
    public function index()
    {
        # code...
        $this->authorize('viewAny', WebsiteSetting::class);
        return view('admin.setting');
    }

    public function store(Request $request)
    {
        # code...
        $this->authorize('viewAny', WebsiteSetting::class);
        $setting = WebsiteSetting::first();

        if($setting){
            $request->validate([
                'main_logo' => 'nullable|mimes:png,jpg,jpeg',
                'footer_logo' => 'nullable|mimes:png,jpg,jpeg',
                'title' => 'required|string|max:255',
                'title_ar' => 'required|string|max:255',
                'email' => 'required|email',
                'phone' => 'required|string|max:15',
                'address' => 'required|string|max:255',
                'address_ar' => 'required|string|max:255',
                'map_url' => 'nullable',
                'bio' => 'nullable',
                'bio_ar' => 'nullable',
                'facebook' => 'nullable',
                'twitter' => 'nullable',
                'instagram' => 'nullable',
                'youtube' => 'nullable',
                'whatsapp' => 'nullable',
                'linkedin' => 'nullable',
                'behance' => 'nullable',
                'github' => 'nullable',
                'seo_description' => 'nullable',
                'seo_description_ar' => 'nullable',
                'seo_tags' => 'nullable',
                'seo_tags_ar' => 'nullable',
                'seo_image' => 'nullable|mimes:png,jpg,jpeg',
            ]);

            $data = $request->all();
            $tags_array = null;
            if($request->seo_tags)
                $tags_array = explode(',', $request->seo_tags);

            $tags_array_ar = null;
            if($request->seo_tags_ar)
                $tags_array_ar = explode(',', $request->seo_tags_ar);

            $data['seo_tags'] = $tags_array;
            $data['seo_tags_ar'] = $tags_array_ar;
            $data['main_logo'] = $setting->main_logo;
            $data['footer_logo'] = $setting->footer_logo;
            $data['seo_image'] = $setting->seo_image;


            if($request->hasFile('main_logo') && $request->file('main_logo')->isValid()){
                if($setting->main_logo)
                    Storage::disk('works')->delete($setting->main_logo);
                $main_logo = $request->file('main_logo')->store('/','works');
                $data['main_logo'] = $main_logo;
            } 

            if($request->hasFile('footer_logo') && $request->file('footer_logo')->isValid()){
                if($setting->footer_logo)
                    Storage::disk('works')->delete($setting->footer_logo);
                $footer_logo = $request->file('footer_logo')->store('/','works');
                $data['footer_logo'] = $footer_logo;
            } 

            if($request->hasFile('seo_image') && $request->file('seo_image')->isValid()){
                if($setting->seo_image)
                    Storage::disk('works')->delete($setting->seo_image);
                $seo_image = $request->file('seo_image')->store('/','works');
                $data['seo_image'] = $seo_image;
            }
             
            
            $setting->update($data);
        } else {
            $request->validate([
                'main_logo' => 'required|mimes:png,jpg,jpeg',
                'footer_logo' => 'required|mimes:png,jpg,jpeg',
                'title' => 'required|string|max:255',
                'title_ar' => 'required|string|max:255',
                'email' => 'required|email',
                'phone' => 'required|string|max:15',
                'address' => 'required|string|max:255',
                'address_ar' => 'required|string|max:255',
                'map_url' => 'nullable',
                'bio' => 'nullable',
                'bio_ar' => 'nullable',
                'facebook' => 'nullable',
                'twitter' => 'nullable',
                'instagram' => 'nullable',
                'youtube' => 'nullable',
                'whatsapp' => 'nullable',
                'linkedin' => 'nullable',
                'behance' => 'nullable',
                'github' => 'nullable',
                'seo_description' => 'nullable',
                'seo_description_ar' => 'nullable',
                'seo_tags' => 'nullable',
                'seo_tags_ar' => 'nullable',
                'seo_image' => 'nullable|mimes:png,jpg,jpeg',
            ]);

            $data = $request->all();
            $tags_array = null;
            if($request->seo_tags)
                $tags_array = explode(',', $request->seo_tags);
            $tags_array_ar = null;
            if($request->seo_tags_ar)
                $tags_array_ar = explode(',', $request->seo_tags_ar);

            $data['seo_tags'] = $tags_array;
            $data['seo_tags_ar'] = $tags_array_ar;
            $data['main_logo'] = null;
            $data['footer_logo'] = null;
            $data['seo_image'] = null;


            if($request->hasFile('main_logo') && $request->file('main_logo')->isValid()){
                $main_logo = $request->file('main_logo')->store('/','works');
                $data['main_logo'] = $main_logo;
            } 

            if($request->hasFile('footer_logo') && $request->file('footer_logo')->isValid()){
                $footer_logo = $request->file('footer_logo')->store('/','works');
                $data['footer_logo'] = $footer_logo;
            }

            if($request->hasFile('seo_image') && $request->file('seo_image')->isValid()){
                $seo_image = $request->file('seo_image')->store('/','works');
                $data['seo_image'] = $seo_image;
            }

            WebsiteSetting::create($data);
        }

        return redirect()->route('c-panel.setting')->with('success', __('Updated Done !'));
    }

}

