<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Group;
use App\Models\Plan;
use Illuminate\Http\Request;

class PlansController extends Controller
{
    public function index(Request $request, Group $group)
    {
        $this->authorize('viewAny',Plan::class);
        if ($request->ajax()) {
            // dd($request->all());
            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Plan::where('group_id', $group->id)->select('count(*) as allcount')->count();
            $totalRecordswithFilter = Plan::where('group_id', $group->id)->select('count(*) as allcount')
                ->where('title', 'like', '%' . $searchValue . '%')
                ->count();

            $plans = Plan::where('group_id', $group->id)->select('plans.*')
                ->where('title', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('plans.id', 'desc')
                ->get();


            $records = [];

            foreach($plans as $item)
            {
                $records[] = [
                    'record_select' =>view('admin.groups.plans.datatable.record',[ 'item' => $item ])->render(),
                    'title' => $item->title,
                    'description' => $item->description ?? __('Not Entered'),
                    'Annual' => $item->prices()->where('type', 3)->first()->price ?? __('Not Entered'),
                    'actions' => view('admin.groups.plans.datatable.buttons',[ 'item' => $item ])->render() ,
                ];
            }

            $response = [
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordswithFilter,
                "aaData" => $records
            ];

            return response()->json($response);

        }

        return view('admin.groups.plans.index', [
            'group' => $group
        ]);
    }

    public function create(Group $group)
    {
        # code...
        $this->authorize('create',Plan::class);
        return view('admin.groups.plans.create', [
            'group' => $group
        ]);
    }

    public function store(Request $request, Group $group)
    {
        # code...
        $this->authorize('create',Plan::class);
        // dd($request->all());
        if($request->check_1){
            $request->validate([
                'price_1' => 'required|numeric',
            ]);
        }
        if($request->check_2){
            $request->validate([
                'price_2' => 'required|numeric',
            ]);
        }
        if($request->check_3){
            $request->validate([
                'price_3' => 'required|numeric',
            ]);
        }
        if($request->check_4){
            $request->validate([
                'price_4' => 'required|numeric',
            ]);
        }
        if($request->check_5){
            $request->validate([
                'price_5' => 'required|numeric',
            ]);
        }
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'features' => 'array|required',
            'features.*' => 'string|required|max:255',
            'price_1' => 'numeric|nullable',
            'price_2' => 'numeric|nullable',
            'price_3' => 'numeric|nullable',
            'price_4' => 'numeric|nullable',
            'price_5' => 'numeric|nullable',
        ]);

        $data = $request->except(['features', 'price_1', 'price_2', 'price_3', 'price_4', 'price_5']);

        $plan = $group->plans()->create($data);

        if($request->price_1 && $request->check_1){
            $plan->prices()->create([
                'price' => $request->price_1,
                'type' => 1,
                'currancy' => 1,
            ]);
        }

        if($request->price_2 && $request->check_2){
            $plan->prices()->create([
                'price' => $request->price_2,
                'type' => 2,
                'currancy' => 1,
            ]);
        }

        if($request->price_3  && $request->check_3){
            $plan->prices()->create([
                'price' => $request->price_3,
                'type' => 3,
                'currancy' => 1,
            ]);
        }

        if($request->price_4 && $request->check_4){
            $plan->prices()->create([
                'price' => $request->price_4,
                'type' => 4,
                'currancy' => 1,
            ]);
        }

        if($request->price_5 && $request->check_5){
            $plan->prices()->create([
                'price' => $request->price_5,
                'type' => 5,
                'currancy' => 1,
            ]);
        }

        foreach($request->features as $feature)
        {
            $plan->features()->create([
                'name' => $feature,
            ]);
        }

        return redirect()->route('c-panel.plans.index', $group->id)->with('success', __('Added Done !'));

    }

    public function edit(Plan $plan)
    {
        # code...
        $this->authorize('update',$plan);
        return view('admin.groups.plans.edit', [
            'plan' => $plan,
            'group' => $plan->group,
        ]);
    }

    public function update(Request $request, Plan $plan)
    {
        # code...
        $this->authorize('update',$plan);
        if($request->check_1){
            $request->validate([
                'price_1' => 'required|numeric',
            ]);
        }
        if($request->check_2){
            $request->validate([
                'price_2' => 'required|numeric',
            ]);
        }
        if($request->check_3){
            $request->validate([
                'price_3' => 'required|numeric',
            ]);
        }
        if($request->check_4){
            $request->validate([
                'price_4' => 'required|numeric',
            ]);
        }
        if($request->check_5){
            $request->validate([
                'price_5' => 'required|numeric',
            ]);
        }
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'features' => 'array|required',
            'features.*' => 'string|required|max:255',
            'price_1' => 'numeric|nullable',
            'price_2' => 'numeric|nullable',
            'price_3' => 'numeric|nullable',
            'price_4' => 'numeric|nullable',
            'price_5' => 'numeric|nullable',
        ]);

        $data = $request->except(['features', 'price_1', 'price_2', 'price_3', 'price_4', 'price_5']);

        $plan->update($data);

        $plan->prices()->delete();
        if($request->price_1 && $request->check_1){
            $plan->prices()->create([
                'price' => $request->price_1,
                'type' => 1,
                'currancy' => 1,
            ]);
        }

        if($request->price_2 && $request->check_2){
            $plan->prices()->create([
                'price' => $request->price_2,
                'type' => 2,
                'currancy' => 1,
            ]);
        }

        if($request->price_3  && $request->check_3){
            $plan->prices()->create([
                'price' => $request->price_3,
                'type' => 3,
                'currancy' => 1,
            ]);
        }

        if($request->price_4 && $request->check_4){
            $plan->prices()->create([
                'price' => $request->price_4,
                'type' => 4,
                'currancy' => 1,
            ]);
        }

        if($request->price_5 && $request->check_5){
            $plan->prices()->create([
                'price' => $request->price_5,
                'type' => 5,
                'currancy' => 1,
            ]);
        }

        $plan->features()->delete();

        foreach($request->features as $feature)
        {
            $plan->features()->create([
                'name' => $feature,
            ]);
        }

        return redirect()->route('c-panel.plans.index', $plan->group_id)->with('success', __('Updated Done !'));

    }

    public function destroy(Plan $plan)
    {
        # code...
        $this->authorize('delete',$plan);
        $plan->delete();
        return redirect()->route('c-panel.plans.index', $plan->group_id)->with('success', __('Deleted Done !'));
    }

    public function bulkDelete()
    {
        // dd(json_decode(request()->record_ids));
        if(count(json_decode(request()->record_ids)) != 0){
            foreach (json_decode(request()->record_ids) as $recordId) {
                $plan = Plan::FindOrFail($recordId);
                $this->authorize('delete',$plan);
                $this->delete($plan);
            }//end of for each
        }else{
            return redirect()->back()->with('error',__('Please Select Record Before Delete'));
        }

        return redirect()->back()->with('success',__('Selected  Deleted Done !'));
    }// end of bulkDelete

    private function delete(Plan $plan)
    {
        $this->authorize('delete',$plan);
        $plan->delete();
    }

}
