<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Domin;
use Illuminate\Http\Request;

class DominsController extends Controller
{
     /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $this->authorize('viewAny', Domin::class);
        if ($request->ajax()) {
            // dd($request->all());
            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Domin::select('count(*) as allcount')->count();
            $totalRecordswithFilter = Domin::select('count(*) as allcount')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->count();

            $domins = Domin::select('domins.*')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('domins.id', 'desc')
                ->get();


            $records = [];

            foreach($domins as $item)
            {
                $currancy = '';
                if($item->currancy == 0) {
                    $currancy = '$';
                } else if ($item->currancy == 1) {
                    $currancy = 'SAR';
                } else if ($item->currancy == 2) {
                    $currancy = 'ILS';
                }
                $records[] = [
                    'record_select' =>view('admin.domins.datatable.record',[ 'item' => $item ])->render(),
                    'id' => $item->id,
                    'name' => $item->name,
                    'price' => $item->price . ' ' . $currancy,
                    'actions' => view('admin.domins.datatable.buttons',[ 'item' => $item ])->render() ,
                ];
            }

            $response = [
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordswithFilter,
                "aaData" => $records
            ];

            return response()->json($response);

        }

        return view('admin.domins.index');
    }

    public function store(Request $request)
    {
        $this->authorize('create', Domin::class);
        $request->validate([
            'name' => 'required|string|max:255',
            'price' => 'required|numeric',
            'description' => 'nullable|string',
        ]);

        $data = $request->all();
        $data['currancy'] = 1;
        Domin::create($data);

        return redirect()->route('c-panel.domins.index')->with('success',__('Added Done !'));
    }


    public function update(Request $request, Domin $domin)
    {
        # code...
        $this->authorize('update', $domin);
        $request->validate([
            'name' => 'required|string|max:255',
            'price' => 'required|numeric',
            'description' => 'nullable|string',
        ]);

        $data = $request->all();
        $data['currancy'] = 1;
        $domin->update($data);

        return redirect()->route('c-panel.domins.index')->with('success',__('Updated Done !'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Domin $domin)
    {
        $this->authorize('delete', $domin);
        $domin->delete();
        return redirect()->route('c-panel.domins.index')->with('success',__('Deleted Done !'));
    }

    public function bulkDelete()
    {
        // dd(json_decode(request()->record_ids));
        if(count(json_decode(request()->record_ids)) != 0){
            foreach (json_decode(request()->record_ids) as $recordId) {
                $domin = Domin::FindOrFail($recordId);
                $this->authorize('delete', $domin);
                $this->delete($domin);
            }//end of for each
        }else{
            return redirect()->route('c-panel.domins.index')->with('error',__('Please Select Record Before Delete'));
        }

        return redirect()->route('c-panel.domins.index')->with('success',__('Selected  Deleted Done !'));
    }// end of bulkDelete

    private function delete(Domin $domin)
    {
        $this->authorize('delete', $domin);
        $domin->delete();
    }
}
